#pragma once
#include "Config.h"
#include "PhoneBook.h"
//////////////////////////////////////////////////////////////////////////////
#define	kPhbCfgSection						"PHB"
#define	kPhbDefaultCurrentBook				"FD"

#define	kTelPhbDC							"DC"
#define	kTelPhbEN							"EN"
#define	kTelPhbFD							"FD"
#define	kTelPhbLD							"LD"
#define	kTelPhbMC							"MC"
#define	kTelPhbME							"ME"
#define	kTelPhbMT							"MT"
#define	kTelPhbON							"ON"
#define	kTelPhbRC							"RC"
#define	kTelPhbSM							"SM"
#define	kTelPhbTA							"TA"

#define	kPhbCurrentBookKey					"Current"
#define	kPhbMaxNameLengthKey				"MaxNameLen"
#define	kPhbFDProtectedKey					"FDProtected"
#define kBookFileNameLength					10
#define	kPhbDefaultFDProtected				1

#define kPhbFirstIndex						1     //Must be greater than 0 (zero)

#define	kPhbErrInvalidEntryIndex			1
#define	kPhbErrInvalidPhoneBookIndex		2
#define	kPhbWarningEmptyEntryIndex			3
#define	kPhbWarningNoEntries				4

#define kPhbDefaultNumber					"5551024896"
#define	kPhbDefaultName						"Voice"
//////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport)
#endif
//////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CConfigPHB : public CConfig
{
private:
	virtual void		ClearPHBList();
protected:
	CList<CPhoneBook*,CPhoneBook*>	mPHBList; // List of Phonebooks
	CStringList						mPHBNameList; // List of phonebooks name
	int								mMaxNameLength;
	bool							mFDProtected;
	// CPBS
	CString							mStorage;
public:
	CConfigPHB() {};
	CConfigPHB(CDllManager* iDllManager);
	virtual ~CConfigPHB(void);

	// Load Params and Phonebooks
	virtual Bool		Load();
	// Save Params and Phonebooks
	virtual Bool		Save();
	
	// GET	
	virtual CPhoneBook*	GetPHB(CString iPhbID);
	virtual CPhoneBook* GetCurrentPHB();
	virtual int			GetMaxNameLength();
	virtual bool		IsFDProtected();
	virtual CStringList* GetPHBNameList();
	// GET CPBS
	virtual CString		GetStorage();
	// SET
	virtual void		SetMaxNameLength(int iMax);
	virtual void		SetFDProtected(bool iProtec);
	// SET CPBS
    virtual void		SetStorage(CString iStorage);
	// OTHER
	virtual void		CheckLength();
	virtual void		AddPhoneBook(CString iName);
	virtual void		RemovePhoneBook(CString iName);	
};
